
********************************************************************************************************************************************************************************
* Table 1. Phillips Curve Estimates: Median CPI Inflation.
********************************************************************************************************************************************************************************

* 1.1. Quarterly

***************************************************************
* Read in data
***************************************************************

set more off
clear
* Put name of your main directory path here:
local main = "___"
cd `main'
use data_quarterly.dta, clear

set scheme s1color
cd "results\tables"

***************************************************************
* Data work
***************************************************************

* Sample dummies

forval s = 1/4 {
	g sample`s' = 0
}
replace sample1 = 1 if (t>=tq(1968q1)) & (t<=tq(1972q4))
replace sample2 = 1 if (t>=tq(1973q1)) & (t<=tq(1984q4))
replace sample3 = 1 if (t>=tq(1985q1)) & (t<=tq(2019q4))
replace sample4 = 1 if (t>=tq(2020q1)) & (t<=tq(2022q3))

g sample13 = 0
replace sample13 = 1 if (sample1==1 | sample3==1)
g sample34 = 0
replace sample34 = 1 if (sample3==1 | sample4==1)


* Relative price fluctuations (supply shocks)
g his			= CPI - Median
* 12-month average
gen his_4qma	= (1/4)*(his + his[_n-1] + his[_n-2] + his[_n-3])

* Overall sample
keep if (t>=tq(1968q1)) & (t<=tq(2022q3))

* Define PC variables:
cap drop y* x*
g y		= Median-pe

* Loop over measures of slack
	* Define measure of slack ("x")
	cap drop x*
	g x		= vu_4qa
	g x2	= x^2
	g x3	= x^3
	gen z	= his_4qma
	gen z2	=z^2
	gen z3	=z^3
	
	label variable x "V/U"
	label variable x2 "V/U-squared"
	label variable x3 "V/U-cubed"
	
	label variable z "H"
	label variable z2 "H-squared"
	label variable z3 "H-cubed"
	
* H: Headline-inflation shock
	
	local ctitle = "Quarterly 1985-2019"
	reg y x x2 x3 z z2 z3 if sample3==1
	outreg2 using "Table1OLS.xls", dec(3) label  ctitle("`ctitle'") addstat("Rbar-squared", e(r2_a)) replace
	newey y x x2 x3 z z2 z3   if sample3==1,  lag(4)
	test x x2 x3
	test x2 x3
	test z z2 z3
	outreg2 using "Table1NEWEY.xls", dec(3) label  ctitle("`ctitle'") replace
		
	local ctitle = "Quarterly 1985-2022"
	reg y x x2 x3 z z2 z3   if sample34==1
	outreg2 using "Table1OLS.xls", dec(3) label  ctitle("`ctitle'") addstat("Rbar-squared", e(r2_a)) append
	newey y x x2 x3 z z2 z3   if sample34==1,  lag(4)
	test x x2 x3
	test x2 x3
	test z z2 z3
	outreg2 using "Table1NEWEY.xls", dec(3) label  ctitle("`ctitle'") append

* 1.2. Monthly	

***************************************************************
* Read in data
***************************************************************

set more off
clear
cd `main'
use data_monthly.dta, clear

***************************************************************
* Set color scheme (optional)
***************************************************************

cd "results\tables"

***************************************************************
* Data work
***************************************************************

* Sample dummies
forval s = 1/4 {
	g sample`s' = 0
}
replace sample1 = 1 if (t>=tm(1968m1)) & (t<=tm(1972m12))
replace sample2 = 1 if (t>=tm(1973m1)) & (t<=tm(1984m12))
replace sample3 = 1 if (t>=tm(1985m1)) & (t<=tm(2019m12))
replace sample4 = 1 if (t>=tm(2020m1)) & (t<=tm(2022m9))


g sample13 = 0
replace sample13 = 1 if (sample1==1 | sample3==1)
g sample34 = 0
replace sample34 = 1 if (sample3==1 | sample4==1)


* Relative price fluctuations (supply shocks)
g his			= CPI - Median
* 12-month average
gen his_12ma	= (1/12)*(his + his[_n-1] + his[_n-2] + his[_n-3] + his[_n-4] + his[_n-5] + his[_n-6] + his[_n-7] + his[_n-8] + his[_n-9] + his[_n-10] + his[_n-11])

* Overall sample
keep if (t>=tm(1968m1)) & (t<=tm(2022m9))

* Define PC variables:
cap drop y* x*
g y		= Median-pe

* Loop over measures of slack
	* Define measure of slack ("x")
	cap drop x*
	g x		= vu_12ma
	g x2	= x^2
	g x3	= x^3
	gen z	= his_12ma
	gen z2	=z^2
	gen z3	=z^3
	
	label variable x "V/U"
	label variable x2 "V/U-squared"
	label variable x3 "V/U-cubed"
	
	label variable z "H"
	label variable z2 "H-squared"
	label variable z3 "H-cubed"
	
	* H: Headline-inflation shock
	
	local ctitle = "Monthly 1985-2019"
	reg y x x2 x3 z z2 z3   if sample3==1
	outreg2 using "Table1OLS.xls", dec(3) label  ctitle("`ctitle'") addstat("Rbar-squared", e(r2_a)) append
	newey y x x2 x3 z z2 z3   if sample3==1,  lag(12)
	test x x2 x3
	test x2 x3
	test z z2 z3
	outreg2 using "Table1NEWEY.xls", dec(3) label  ctitle("`ctitle'") append
	
	local ctitle = "Monthly 1985-2022"
	reg y x x2 x3 z z2 z3   if sample34==1
	outreg2 using "Table1OLS.xls", dec(3) label  ctitle("`ctitle'") addstat("Rbar-squared", e(r2_a)) append
	newey y x x2 x3 z z2 z3   if sample34==1,  lag(12)
	matrix list e(V)
	test x x2 x3
	test x2 x3
	test z z2 z3
	outreg2 using "Table1NEWEY.xls", dec(3) label  ctitle("`ctitle'") append
	
	cd `main'